/*
 * Decompiled with CFR 0.152.
 */
package org.gldhn.mcsleep;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gldhn.common;
import org.gldhn.mcsleep.McServerConfig;
import org.gldhn.mcsleep.McServerNet;
import org.gldhn.mcsleep.config;

public class RunJarWithArgs {
    static boolean runJar = false;
    public static OutputStream PrInput = null;
    public static boolean restart = false;
    private static Process process;
    private static ScheduledExecutorService scheduler;

    RunJarWithArgs() {
    }

    public static boolean start() {
        runJar = true;
        restart = false;
        String commandString = config.getRunCommand();
        List<String> commandList = RunJarWithArgs.parseCommand(commandString);
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        try {
            process = processBuilder.start();
            PrInput = process.getOutputStream();
            Thread outputThread = new Thread(() -> RunJarWithArgs.readStream(process.getInputStream(), "[SERVER]"));
            outputThread.start();
            Thread errorThread = new Thread(() -> RunJarWithArgs.readStream(process.getErrorStream(), "[ERROR]"));
            errorThread.start();
            scheduler = Executors.newScheduledThreadPool(1);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (process.isAlive()) {
                    process.destroy();
                    try {
                        if (!process.waitFor(5L, TimeUnit.SECONDS)) {
                            process.destroyForcibly();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }));
            Runnable task = () -> RunJarWithArgs.sendInputToProcess(process.getOutputStream());
            if (config.getNoOneClose().booleanValue()) {
                scheduler.scheduleAtFixedRate(task, 0L, config.getWaitingTime() * 60, TimeUnit.SECONDS);
            }
            int exitCode = process.waitFor();
            common.Logger("\u5b50\u8fdb\u7a0b\u9000\u51fa\uff0c\u9000\u51fa\u7801\uff1a" + exitCode, 0);
            runJar = false;
            PrInput = null;
            if (config.getNoOneClose().booleanValue()) {
                scheduler.shutdown();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return restart;
    }

    public static void Rescheduler() {
        if (runJar) {
            scheduler.shutdown();
            scheduler = Executors.newScheduledThreadPool(1);
            Runnable task = () -> RunJarWithArgs.sendInputToProcess(process.getOutputStream());
            if (config.getNoOneClose().booleanValue()) {
                scheduler.scheduleAtFixedRate(task, 0L, config.getWaitingTime() * 60, TimeUnit.SECONDS);
            }
        }
    }

    public static void stop() {
        try {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        runJar = false;
        common.Logger("\u505c\u6b62\u5b50\u8fdb\u7a0b", 0);
    }

    private static void readStream(InputStream inputStream, String streamType) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null && runJar) {
                common.Logger(streamType + ": " + line, 3);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void sendInputToProcess(OutputStream outputStream) {
        int onlinePlayer = McServerNet.GetServerInfo("127.0.0.1", McServerConfig.port);
        if (onlinePlayer == 0) {
            config.setCount(config.getCount() + 1);
            common.Logger("onlinePlayer==0 -> count:" + config.getCount(), 3);
        } else {
            config.setCount(0);
        }
        if (config.getCount() < config.getMaxZero()) {
            return;
        }
        try {
            String input = "stop";
            outputStream.write((input + System.lineSeparator()).getBytes());
            outputStream.flush();
            common.Logger("Sent command: " + input.trim(), 3);
            restart = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> parseCommand(String commandString) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]*)\"|\\S+").matcher(commandString);
        while (matcher.find()) {
            String match = matcher.group(1) != null ? matcher.group(1) : matcher.group(0);
            result.add(match);
        }
        return result;
    }
}

